<?php


/**
 * Use to autoload needed classes without Composer.
 *
 * @param string $class The fully-qualified class name.
 *
 * @return void
 */
spl_autoload_register( function ( $class ) {

	// project-specific namespace prefix
	$prefix = 'Abraham\\TwitterOAuth\\';

	// base directory for the namespace prefix
	$base_dir = __DIR__ . '/';

	// does the class use the namespace prefix?
	$len = strlen( $prefix );
	if ( strncmp( $prefix, $class, $len ) !== 0 ) {
		// no, move to the next registered autoloader
		return;
	}

	// get the relative class name
	$relative_class = substr( $class, $len );

	// replace the namespace prefix with the base directory, replace namespace
	// separators with directory separators in the relative class name, append
	// with .php
	$file = $base_dir . str_replace( '\\', '/', $relative_class ) . '.php';

	// if the file exists, require it
	if ( file_exists( $file ) ) {
		require $file;
	}
} );

use Abraham\TwitterOAuth\TwitterOAuth;

$connection = new TwitterOAuth(
	'X8x3YfVrb7BEE6hSBF8W0Frfc',
	'IhPTepTaHyisRZk7Qxq8zneGITCWgeXI8KyjXNPkW4x7ITqg7u',
	'561144654-rIWgo8Aup2tyLLvUi2owTxH0g8tsYusgMTG6bI3r',
	'HZZYk6dpSmL9WcRhwrcWdHsQhFmPuoraQEj2ORpr3zUFV'
);